<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    // Manually set session variables to simulate a logged-in user
    $_SESSION['loggedin'] = true;
    $_SESSION['user_id'] = 2; // Replace with an actual user_id from your database
    $_SESSION['role'] = 'user'; // Or any other role you want to test with
    $_SESSION['email'] = 'ftest@faida.com'; // Replace with the user's email

    // Redirect to the dashboard that you want to test
    // Ensure this points to a page different from the login page to avoid a redirect loop
    header('Location: index.php'); // Change this to the appropriate dashboard page
    exit();
}
?>


<!DOCTYPE html>
<html lang="en">
    <head>
    <?php $title = "Log In";
    include 'partials/title-meta.php'; ?>

		<?php include 'partials/head-css.php'; ?>

    </head>

    <body class="loading authentication-bg authentication-bg-pattern">

        <div class="account-pages my-5">
            <div class="container">

                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6 col-xl-4">
                        <div class="text-center">   
                            <a href="index.php">
                                <img src="assets/images/faida-logo.png" alt="" height="40" class="mx-auto">
                            </a>
                            <p class="text-muted mt-2 mb-4">Faida System</p>

                        </div>
                        <div class="card">
                            <div class="card-body p-4">
                                
                                <div class="text-center mb-4">
                                    <h4 class="text-uppercase mt-0">Sign In</h4>
                                </div>
                                <!-- Check for session error message -->
                                <?php if (!empty($_SESSION['error'])): ?>
                                    <div class="alert alert-danger" role="alert">
                                        <?php echo $_SESSION['error']; ?>
                                    </div>
                                <?php endif; ?>
                                <form method="POST">
                                    <div class="mb-3">
                                        <label for="emailaddress" class="form-label">Email address</label>
                                        <input class="form-control" type="email" id="emailaddress" placeholder="Enter your email" name="email" value="<?php echo ($_POST['email'] ?? "demo@customer.com") ?>">
                                        <span class="text-danger"><?php echo $_SESSION['error'] ?></span>
                                    </div>

                                    <div class="mb-3">
                                        <label for="password" class="form-label">Password</label>
                                        <input class="form-control" type="password" id="password" placeholder="Enter your password">
                                    </div>

                                    <div class="mb-3">
                                        <div class="form-check">
                                            <input type="checkbox" class="form-check-input" id="checkbox-signin" checked>
                                            <label class="form-check-label" for="checkbox-signin">Remember me</label>
                                        </div>
                                    </div>

                                    <div class="mb-3 d-grid text-center">
                                        <button class="btn btn-primary" type="submit"> Log In </button>
                                    </div>
                                </form>

                            </div> <!-- end card-body -->
                        </div>
                        <!-- end card -->

                        <div class="row mt-3">
                            <div class="col-12 text-center">
                                <p> <a href="auth-recoverpw.php" class="text-muted ms-1"><i class="fa fa-lock me-1"></i>Forgot your password?</a></p>
                                <p class="text-muted">Don't have an account? <a href="auth-register.php" class="text-dark ms-1"><b>Sign Up</b></a></p>
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- end container -->
        </div>
        <!-- end page -->

        <?php include 'partials/footer-scripts.php'; ?>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>
</html>